//
//  GSSubstitution.h
//  Glyphs
//
//  Created by Georg Seifert on 9.9.07.
//  Copyright 2007 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GlyphsCore/GSBase.h>

typedef enum : uint8_t {
	GSSubstitutionSingle,
	GSSubstitutionLigature,
	GSSubstitutionContext,
} GSSubstitutionType;

@interface GSSubstitution : NSObject <NSCoding, NSCopying> {
	NSString *_back;
	NSString *_source;
	NSString *_fwd;
	NSString *_target;
	BOOL _ignore;
	NSArray *_languageTags;
	NSString *_scriptTag;
	NSString *_lookupFlag;
}
/// Context glyphs (as glyph names) before the source.
/*
 As glyph names.
 */
@property (strong, nonatomic) NSString *back;
/// The source  glyphs.
/*
 As glyph names.
 */

@property (strong, nonatomic) NSString *source;
/// Context glyphs after the source.
/*
 As glyph names.
 */

@property (strong, nonatomic) NSString *fwd;
/// The target glyphs.
/*
 As glyph names.
 */
@property (strong, nonatomic) NSString *target;

/// this is a ignore-substitution
@property (nonatomic) BOOL ignore;
/// the language tags
@property (strong, nonatomic) NSArray <GSLanguageTag> *languageTags;
/// the script tag
@property (strong, nonatomic) GSScriptTag scriptTag;
/// the lookupFlag
@property (strong, nonatomic) NSString *lookupFlag;

@property (nonatomic, readonly) GSSubstitutionType type;

/// Init with dictionary loaded from pList.
- (instancetype)initWithDict:(NSDictionary *)dict;

/// Init with String in OT syntax.
- (instancetype)initWithCode:(NSString *)code;

/** Returns the content of the object to store it in pList.

 This is used to store the data in the .glyphs file.
 @param format the version of the dict
 */
- (NSDictionary *)propertyListValueFormat:(GSFormatVersion)format;

/// The substitution representation in FDK syntax.
- (NSString *)code;
@end
